#!/usr/bin/python
# coding: UTF-8
# Rec10 TS Recording Tools
# Copyright (C) 2009-2010 Yukikaze
import commands
import configreader
import os
import os.path
import re
import random

import recdblist
def ts2x264(pin, pout, opts):#sizeは"HD"か"SD"
    """
    pinで指定されたファイルをpoutにx264でエンコードして書き出す
    """
    dualpass = 0
    is24fps=0
    size="HD"
    crf=18
    quality=4
    quality=int(configreader.getenv("x264_preset"))
    crf=int(configreader.getenv("crf"))
    if re.search("H", opts):
        size = "HD"
    if re.search("S", opts):
        size = "SD"
    if re.search("F", opts):
        size = "FullHD"
    if re.search("W",opts):
        size = "WVGA"
    if re.search("MW8", opts):
        size = "QVGA_BASE"
        crf=crf+4
    if re.search("MW9", opts):
        size = "WVGA_BASE"
        crf=crf+2
    if re.search("v", opts):
        is24fps=1
        crf=int(configreader.getenv("animation_crf"))
    if re.search("a", opts):
        is24fps=1
        crf=int(configreader.getenv("animation_crf"))
    if re.search("q",opts):
        quality=quality-2
    if re.search("w",opts):
        quality=quality-1
    if re.search("e",opts):
        quality=quality+1
    if re.search("r",opts):
        quality=quality+2
    if re.search("u",opts):
        crf=crf+2
    if re.search("i",opts):
        crf=crf+1
    if re.search("o",opts):
        crf=crf-1
    if re.search("p",opts):
        crf=crf-2
    if re.search("d",opts):
        encode_ffmpeg(pin,pout,size,is24fps,quality,crf)
    elif re.search("5",opts):
        encode_ffmpeg(pin,pout,size,is24fps,quality,crf)
    else:
        try:
            encode(pin, pout,size,is24fps,quality,crf)
        except Exception, inst:
            recdblist.printutf8("error occures in ts2x264.py encode")
            recdblist.printutf8(str(type(inst)))
            recdblist.printutf8(str(inst))
def encode(pin,pout,size,is24fps,quality,crf):
    mencoder=configreader.getpath("mencoder")
    x264=configreader.getpath("x264")
    encvf=""
    txt=""
    encvf="-vf yadif=0,pp=l5"
    harddup=",hqdn3d=2:1:2,unsharp=l3x3:0.75:c3x3:0.75,harddup"
    ofps="-ofps 30000/1001"
    fps="-fps 30000/1001"
    x264fps="--fps 30000/1001"
    x264streamsize=""
    x264preset=""
    x264tune=""
    x264_bitrate="5000"
    x264_addline=configreader.getenv("x264_addline")
    if is24fps==1:
        ofps="-ofps 24000/1001"
        fps="-fps 30000/1001"
        x264fps="--fps 24000/1001"
        x264tune="--tune animation"
        encvf="-vf pullup,softskip"
        harddup=",pp=l5,unsharp=l3x3:0.75:c3x3:0.75,hqdn3d=2:1:2,harddup"
    if size == "HD":
        encvf = encvf + ",scale=-2:720::0:3,expand=1280:720"+harddup
        x264streamsize=u"1280x720"
        x264_bitrate="2500"
    elif size == "WVGA":
        encvf = encvf + ",scale=-2:480::0:3,expand=854:480"+harddup
        x264streamsize=u"854x480"
        x264_bitrate="1500"
    elif size == "FullHD":
        encvf = encvf + ",scale=-2:1080::0:3,expand=1920:1080"+harddup
        x264streamsize=u"1920x1080"
        x264_bitrate="5000"
    elif size == "SD":
        encvf = encvf + ",scale=720:-2::0:3,expand=720:480"+harddup
        x264streamsize=u"720x480"
        x264_bitrate="1250"
    elif size == "QVGA_BASE":
        encvf = encvf + ",scale=320:-2::0:3,expand=320:240"+harddup
        x264streamsize=u"320x240"
        x264_bitrate="300"
    elif size == "WVGA_BASE":
        encvf = encvf + ",scale=-2:480::0:3,expand=854:480"+harddup
        x264streamsize=u"854x480"
        x264_bitrate="1500"
    else:
        encvf = encvf + ",scale=-2:720::0:3,expand=1280:720"+harddup
        x264streamsize=u"1280x720"
        x264_bitrate="2500"
    if quality==1:
        x264preset=u"--preset ultrafast"
    elif quality==2:
        x264preset=u"--preset veryfast"
    elif quality==3:
        x264preset=u"--preset fast"
    elif quality==4:
        x264preset=u"--preset medium"
    elif quality==5:
        x264preset=u"--preset slow"
    elif quality==6:
        x264preset=u"--preset slower"
    if size == "WVGA_BASE" or size == "QVGA_BASE":
        x264profile=" --level 32 --profile baseline "
    else:
        x264profile=" --level 41 --profile high "
    x264crf=u"--crf "+str(crf)
    os.environ['LANG']="ja_JP.UTF-8"
    random.seed(pin)
    random.jumpahead(10)
    streampath=os.path.join(os.path.dirname(pin),str(random.randint(10000, 999999)))
    os.system(u"mkfifo "+streampath)
    encexe=mencoder+u" \""+pin+u"\" -vfm ffmpeg -quiet -sws 9 "+encvf+u",format=i420 "+fps+" "+ofps+" -oac mp3lame -ovc raw -of rawvideo -o \""+streampath+"\" &"
    encexe=encexe+u" nice -n 19 "+x264+" "+x264crf+u" "+x264_addline+u"  --threads auto"+x264profile+x264preset+" "+x264tune+" "+x264fps+" -o \""+pout+"\" "+streampath+" "+x264streamsize
    encexe=u"nice -n 19 " +encexe
    recdblist.printutf8(encexe)
    txt=txt+"Cmd : "+encexe+"\n"
    txtt=""
    try:
        txtt=unicode(commands.getoutput(encexe.encode('utf-8')),'utf-8')
    except:
        ""
    os.system("rm "+streampath)
    txt=txt+txtt
    recdblist.addlog( pin, txt, "mencoder-log")

def encode_ffmpeg(pin,pout,size,is24fps,quality,crf):
    """
    
    """
    ffmpeg=configreader.getpath("ffmpeg")
    x264=configreader.getpath("x264")
    fps=u"-r 29.970030 "
    x264fps="--fps 30000/1001"
    x264streamsize=""
    x264preset=""
    x264tune=""
    x264_bitrate="2500"
    x264_addline=configreader.getenv("x264_addline")
    if size == "HD":
        s = "-s 1280x720 "
        x264streamsize=u"1280x720"
        x264_bitrate="2500"
    elif size == "WVGA":
        s = "-s 854x480 "
        x264streamsize=u"854x480"
        x264_bitrate="1500"
    elif size == "FullHD":
        s = "-s 1920x1080 "
        x264streamsize=u"1920x1080"
        x264_bitrate="5000"
    elif size == "SD":
        s = "-s 720x480 "
        x264streamsize=u"720x480"
        x264_bitrate="1250"
    elif size == "QVGA_BASE":
        s = "-s 320x240 "
        x264streamsize=u"320x240"
        x264_bitrate="300"
    elif size == "WVGA_BASE":
        s = "-s 854x480 "
        x264streamsize=u"854x480"
        x264_bitrate="1500"
    else:
        s = "-s 1280x720 "
        x264streamsize=u"1280x720"
        x264_bitrate="2500"
    if quality==1:
        x264preset=u"--preset ultrafast"
    elif quality==2:
        x264preset=u"--preset veryfast"
    elif quality==3:
        x264preset=u"--preset fast"
    elif quality==4:
        x264preset=u"--preset medium"
    elif quality==5:
        x264preset=u"--preset slow"
    elif quality==6:
        x264preset=u"--preset slower"
    if size == "WVGA_BASE" or size == "QVGA_BASE":
        x264profile=" --level 32 --profile baseline "
    else:
        x264profile=" --level 41 --profile high "
    x264crf=u"--crf "+str(crf)
    txt=""
    os.environ['LANG']="ja_JP.UTF-8"
    exe=ffmpeg+u" -y -i \""+pin+"\" -vsync 400 -vcodec rawvideo -pix_fmt yuv420p "+s+fps+"-deinterlace -an -f rawvideo - |"
    exe=exe+u" nice -n 19 "+x264+" "+x264crf+u" "+x264_addline+u" --threads auto "+x264profile+x264preset+" "+x264tune+" "+x264fps+" -o \""+pout+"\" - "+x264streamsize
    txt=txt+"Cmd : "+exe+"\n"
    exe = "nice -n 19 " + exe
    txt=txt+"Cmd : "+exe+"\n"
    txtt=""
    recdblist.printutf8(exe)
    try:
        txtt=unicode(commands.getoutput(exe.encode('utf-8')),'utf-8')
    except:
        ""
    txt=txt+txtt
    recdblist.addlog( pin, txt, "dual audio ffmpeg-log")
    